<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\TicketAnswerController;
use App\Http\Controllers\ReferralController;
use App\Http\Controllers\WithdrawController;
use App\Http\Controllers\ShortlinkController;
use App\Http\Controllers\AutoclaimController;
use App\Http\Controllers\StakingController;
use App\Http\Controllers\DepositController;
use App\Http\Controllers\DailyBonusController;
use App\Http\Controllers\admin\AdminShortlinkController;
use App\Http\Controllers\admin\AdminUsersController;
use App\Http\Controllers\admin\AdminTicketsController;
use App\Http\Controllers\admin\AdminSettingsController;
use App\Http\Controllers\admin\AdminCoinsController;
use App\Http\Controllers\admin\AdminStakingController;
use App\Http\Controllers\admin\AdminProxyController;
use App\Http\Controllers\admin\AdminDepositController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [HomeController::class, 'welcome'])->name('welcome');
Route::get('/r/{user}', [HomeController::class, 'ref'])->name('welcome.ref');
Route::get('/terms', [HomeController::class, 'terms'])->name('terms');

Route::get('/dashboard', [UserController::class, 'dashboard'])->middleware(['auth', 'verified'])->name('dashboard');

Route::get('/dashboard/settings', function () {
    return view('settings');
})->middleware(['auth', 'verified'])->name('settings');

Route::post('/settings/update', [UserController::class, 'updatePassword'])->middleware(['auth', 'verified'])->name('settings.update');
Route::post('/settings/withdrawal', [UserController::class, 'updateWallets'])->middleware(['auth', 'verified'])->name('settings.withdrawal');

Route::resource('/dashboard/tickets', TicketController::class)->middleware('auth');
Route::resource('/dashboard/ticketanswer', TicketAnswerController::class)->middleware('auth');
Route::resource('/dashboard/referrals', ReferralController::class)->middleware('auth');
Route::resource('/dashboard/withdraw', WithdrawController::class)->middleware('auth')->except(['show', 'create']);
Route::get('/dashboard/withdraw/{coin}', [WithdrawController::class, 'create'])->middleware(['auth', 'verified'])->name('withdraw.create');

Route::get('/dashboard/shortlinks', [ShortlinkController::class, 'index'])->middleware('auth')->name('shortlinks.index');
Route::get('/dashboard/shortlinks/history', [ShortlinkController::class, 'history'])->middleware('auth')->name('shortlinks.history');
Route::post('/dashboard/shortlinks/visit/{id}', [ShortlinkController::class, 'visit'])->middleware(['auth', 'verified'])->name('shortlinks.visit');
Route::get('/dashboard/shortlinks/visited/{verify_code}', [ShortlinkController::class, 'visited'])->middleware('auth')->name('shortlinks.visited');

Route::get('/dashboard/claim/auto', [AutoclaimController::class, 'index'])->middleware('auth')->name('autoclaim.index');
Route::post('/dashboard/claim/auto/start', [AutoclaimController::class, 'store'])->middleware('auth')->name('autoclaim.store');
Route::get('/dashboard/claim/auto/start', [AutoclaimController::class, 'start'])->middleware('auth')->name('autoclaim.start');
Route::get('/dashboard/claim/auto/api', [AutoclaimController::class, 'service'])->middleware('auth')->name('autoclaim.service');
Route::get('/dashboard/claim/auto/history', [AutoclaimController::class, 'history'])->middleware('auth')->name('autoclaim.history');

Route::resource('/dashboard/staking', StakingController::class)->middleware('auth')->except(['show', 'create']);
Route::get('/dashboard/staking/create/{id}', [StakingController::class, 'create'])->middleware(['auth', 'verified'])->name('staking.create');
Route::get('/dashboard/staking/history', [StakingController::class, 'history'])->middleware(['auth', 'verified'])->name('staking.history');

Route::get('/dashboard/deposit', [DepositController::class, 'index'])->middleware(['auth', 'verified'])->name('deposit.index');
Route::post('/dashboard/deposit', [DepositController::class, 'store'])->middleware(['auth', 'verified'])->name('deposit.store');
Route::get('/dashboard/deposit/order/{id}', [DepositController::class, 'show'])->middleware(['auth', 'verified'])->name('deposit.show');
Route::post('/ipn/deposit', [DepositController::class, 'ipn'])->middleware(['auth', 'verified'])->name('deposit.ipn');
Route::get('/dashboard/deposit/history', [DepositController::class, 'history'])->middleware(['auth', 'verified'])->name('deposit.history');

Route::get('/dashboard/bonus', [DailyBonusController::class, 'index'])->middleware(['auth', 'verified'])->name('bonus.index');
Route::post('/dashboard/bonus', [DailyBonusController::class, 'store'])->middleware(['auth', 'verified'])->name('bonus.store');

//admin
Route::resource('/admin/shortlinks', AdminShortlinkController::class, ['as' => 'admin'])->middleware(['auth', 'admin'])->except('show');
Route::resource('/admin/users', AdminUsersController::class, ['as' => 'admin'])->middleware(['auth', 'admin'])->except(['show', 'destroy', 'create', 'store']);
Route::resource('/admin/tickets', AdminTicketsController::class, ['as' => 'admin'])->middleware(['auth', 'admin'])->except(['edit', 'destroy', 'create', 'store']);
Route::post('/admin/ticket/reply', [AdminTicketsController::class, 'adminReply'])->middleware(['auth', 'admin'])->name('admin.ticket.reply');
Route::get('/admin/settings', [AdminSettingsController::class, 'index'])->middleware(['auth', 'admin'])->name('admin.settings');
Route::post('/admin/settings/update', [AdminSettingsController::class, 'update'])->middleware(['auth', 'admin'])->name('admin.settings.update');
Route::resource('/admin/coins', AdminCoinsController::class, ['as' => 'admin'])->middleware(['auth', 'admin'])->except('show');
Route::resource('/admin/staking', AdminStakingController::class, ['as' => 'admin'])->middleware(['auth', 'admin'])->except('show');
Route::get('/staking/api/{key}', [StakingController::class, 'apistaking'])->name('staking.api');
Route::get('/admin/proxy', [AdminProxyController::class, 'index'], ['as' => 'admin'])->middleware(['auth', 'admin'])->name('admin.proxy.index');
Route::get('/admin/deposit', [AdminDepositController::class, 'index'], ['as' => 'admin'])->middleware(['auth', 'admin'])->name('admin.deposit.index');

require __DIR__.'/auth.php';
